function P83_v
% Problem 8.3 :	Double-Well Potential System
% v. Large Initial Condition Sensitivity

% Define some parameters
x01=[0.177 0.1];          % Initial condition for i)
x02=[0.178 0.1];      % Initial condition for ii)
F=0.25;                 % Amplitude of external force
% Solve equation of motion with initial conditions for i)
[T1,X1]=ode45(@(t,x)DoubleWell(t,x,F),[0,500],x01);
% Solve equation of motion with initial conditions for ii)
[T2,X2]=ode45(@(t,x)DoubleWell(t,x,F),[0,500],x02);
% Plot and compare above two time response
plot(T1,X1(:,1),'r-',T2,X2(:,1),'b--');
grid on; axis tight;
set(gca,'FontSize',14);
xlabel('\bfTime (second)');
ylabel('\bfLateral Trajectory of Particle (a.u.)');
title('\bfInitial Condition Sensitivity for Small External Force F=0.25');
legend('\bfx_0=0.177&v_0=0.1','\bfx_0=0.178&v_0=0.1');
end

function dx=DoubleWell(t,x,F)
% Describe euation of motion
% in the double-well potetial system
dx(1,1)=x(2);
dx(2,1)=F*cos(t)-0.25*x(2)+x(1)-x(1)^3;
end